/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: DevNetFal_error.h 48469 2014-10-09 08:32:07Z trieu                    $

   Description:
    ............................................................................

    Includes following functions:

   Changes:

     Version     Date        Author
     X.X.X.X   DD.MM.JJJJ  Mustermann
     Description................................................................
     ---------------------------------------------------------------------------
     1         06.09.2012     TD
     Created
*******************************************************************************/

#ifndef __DEVNET_FAL_ERROR_H
#define __DEVNET_FAL_ERROR_H

////////////////////////////////////////////////////////////////////////////////
// DeviceNet FAL Task (Fieldbus Application Layer).
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// Error General: Codes 0x01 - 0x0F.
////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_DEVNET_FAL_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_DEVNET_FAL_COMMAND_INVALID ((TLR_RESULT)0xC0470001L)

//
// MessageId: TLR_E_DEVNET_FAL_SERVICE_NOT_SUPPORTED
//
// MessageText:
//
//  Service not supported.
//
#define TLR_E_DEVNET_FAL_SERVICE_NOT_SUPPORTED ((TLR_RESULT)0xC0470002L)

//
// MessageId: TLR_E_DEVNET_FAL_RESET_IN_REQUEST
//
// MessageText:
//
//  Reset is in request.
//
#define TLR_E_DEVNET_FAL_RESET_IN_REQUEST ((TLR_RESULT)0xC0470003L)

//
// MessageId: TLR_E_DEVNET_FAL_UNRECOVER_RESET_FAULT
//
// MessageText:
//
//  Unrecoverable reset fault.
//
#define TLR_E_DEVNET_FAL_UNRECOVER_RESET_FAULT ((TLR_RESULT)0xC0470004L)

////////////////////////////////////////////////////////////////////////////////
// Error Command: SetModeReq 0x10 - 0x1F.
////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_DEVNET_FAL_SET_MODE_INVALID_MODE
//
// MessageText:
//
//  Invalid value for 'mode' of command.
//
#define TLR_E_DEVNET_FAL_SET_MODE_INVALID_MODE ((TLR_RESULT)0xC0470010L)

//
// MessageId: TLR_E_DEVNET_FAL_SET_MODE_ALREADY_IN_REQUEST
//
// MessageText:
//
//  Command already in request.
//
#define TLR_E_DEVNET_FAL_SET_MODE_ALREADY_IN_REQUEST ((TLR_RESULT)0xC0470011L)

////////////////////////////////////////////////////////////////////////////////
// Error Command: ClearConfigReq 0x20 - 0x2F. 
////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_DEVNET_FAL_CLR_CONFIG_NOT_ALLOWED_IN_ACTUAL_STATE
//
// MessageText:
//
//  Not allowed to clear configuration in actual mode.
//
#define TLR_E_DEVNET_FAL_CLR_CONFIG_NOT_ALLOWED_IN_ACTUAL_STATE ((TLR_RESULT)0xC0470020L)

////////////////////////////////////////////////////////////////////////////////
// Error Command: DownloadReq General codes 0x30 - 0x3F.                             
////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_DEVNET_FAL_DOWNLOAD_NOT_ALLOWED_IN_ACTUAL_STATE
//
// MessageText:
//
//  Download not allowed in actual state.
//
#define TLR_E_DEVNET_FAL_DOWNLOAD_NOT_ALLOWED_IN_ACTUAL_STATE ((TLR_RESULT)0xC0470030L)

//
// MessageId: TLR_E_DEVNET_FAL_DOWNLOAD_INVALID_AREA_CODE
//
// MessageText:
//
//  Invalid value in 'AreaCode' of command.
//
#define TLR_E_DEVNET_FAL_DOWNLOAD_INVALID_AREA_CODE ((TLR_RESULT)0xC0470031L)

//
// MessageId: TLR_E_DEVNET_FAL_DOWNLOAD_INVALID_SEQUENCE
//
// MessageText:
//
//  Sequence error.
//
#define TLR_E_DEVNET_FAL_DOWNLOAD_INVALID_SEQUENCE ((TLR_RESULT)0xC0470032L)

//
// MessageId: TLR_E_DEVNET_FAL_DOWNLOAD_TO_MUCH_DATA
//
// MessageText:
//
//  To much data.
//
#define TLR_E_DEVNET_FAL_DOWNLOAD_TO_MUCH_DATA ((TLR_RESULT)0xC0470033L)

//
// MessageId: TLR_E_DEVNET_FAL_DOWNLOAD_TO_LESS_DATA
//
// MessageText:
//
//  Less data.
//
#define TLR_E_DEVNET_FAL_DOWNLOAD_TO_LESS_DATA ((TLR_RESULT)0xC0470034L)

//
// MessageId: TLR_E_DEVNET_FAL_DOWNLOAD_ALLREADY_CONFIGURED
//
// MessageText:
//
//  DeviceNet Stack allready configured.
//
#define TLR_E_DEVNET_FAL_DOWNLOAD_ALLREADY_CONFIGURED ((TLR_RESULT)0xC0470035L)

//
// MessageId: TLR_E_DEVNET_FAL_DOWNLOAD_FAULTY_CONFIGURATION
//
// MessageText:
//
//  DeviceNet Stack with an faulty configured loaded.
//
#define TLR_E_DEVNET_FAL_DOWNLOAD_FAULTY_CONFIGURATION ((TLR_RESULT)0xC0470036L)

//
// MessageId: TLR_E_DEVNET_FAL_DPM_BYTE_ALREADY_MAPPED
//
// MessageText:
//
//  DPM Byte already mapped.
//
#define TLR_E_DEVNET_FAL_DPM_BYTE_ALREADY_MAPPED ((TLR_RESULT)0xC0470037L)

//
// MessageId: TLR_E_DEVNET_FAL_DPM_BYTE_OUT_OF_MEMORY
//
// MessageText:
//
//  DPM Byte out of DPM Memory.
//
#define TLR_E_DEVNET_FAL_DPM_BYTE_OUT_OF_MEMORY ((TLR_RESULT)0xC0470038L)

////////////////////////////////////////////////////////////////////////////////
// Error Command: DownloadReq ValidetParameter 0x100 - 0x1FF.
////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_DEVNET_FAL_BAUDRATE_OUT_OF_RANGE
//
// MessageText:
//
//  Invalid Baudrate.
//
#define TLR_E_DEVNET_FAL_BAUDRATE_OUT_OF_RANGE ((TLR_RESULT)0xC0470100L)

//
// MessageId: TLR_E_DEVNET_FAL_MAC_ID_OUT_OF_RANGE
//
// MessageText:
//
//  Invalid MAC Id.
//
#define TLR_E_DEVNET_FAL_MAC_ID_OUT_OF_RANGE ((TLR_RESULT)0xC0470101L)

//
// MessageId: TLR_E_DEVNET_FAL_ADR_DOUBLE
//
// MessageText:
//
//  Slave already configured.
//
#define TLR_E_DEVNET_FAL_ADR_DOUBLE      ((TLR_RESULT)0xC0470102L)

//
// MessageId: TLR_E_DEVNET_FAL_DATA_SET_FIELD_LEN
//
// MessageText:
//
//  Invalid length of slave parameter set.
//
#define TLR_E_DEVNET_FAL_DATA_SET_FIELD_LEN ((TLR_RESULT)0xC0470103L)

//
// MessageId: TLR_E_DEVNET_FAL_PRED_MST_SL_ADD_LEN
//
// MessageText:
//
//  Invalid length of address table in parameter set.
//
#define TLR_E_DEVNET_FAL_PRED_MST_SL_ADD_LEN ((TLR_RESULT)0xC0470104L)

//
// MessageId: TLR_E_DEVNET_FAL_PRED_MSTSL_CFG_FIELD_LEN
//
// MessageText:
//
//  Invalid length of predefined master slave config table in parameter set.
//
#define TLR_E_DEVNET_FAL_PRED_MSTSL_CFG_FIELD_LEN ((TLR_RESULT)0xC0470105L)

//
// MessageId: TLR_E_DEVNET_FAL_PRED_MST_SL_ADD_TAB_INCONS
//
// MessageText:
//
//  Inconsitency between addresstable and configured connection length.
//
#define TLR_E_DEVNET_FAL_PRED_MST_SL_ADD_TAB_INCONS ((TLR_RESULT)0xC0470106L)

//
// MessageId: TLR_E_DEVNET_FAL_EXPL_PRM_FIELD_LEN
//
// MessageText:
//
//  Invalid Length of explicit parameter data in slave parameter set.
//
#define TLR_E_DEVNET_FAL_EXPL_PRM_FIELD_LEN ((TLR_RESULT)0xC0470107L)

//
// MessageId: TLR_E_DEVNET_FAL_PRED_MSTSL_CFG_ADD_INPUT_INCONS
//
// MessageText:
//
//  Inconsistency between number of input address offsets and configured input modules.
//
#define TLR_E_DEVNET_FAL_PRED_MSTSL_CFG_ADD_INPUT_INCONS ((TLR_RESULT)0xC0470108L)

//
// MessageId: TLR_E_DEVNET_FAL_PRED_MSTSL_CFG_ADD_OUTPUT_INCONS
//
// MessageText:
//
//  Inconsistency between number of output address offsets and configured output modules.
//
#define TLR_E_DEVNET_FAL_PRED_MSTSL_CFG_ADD_OUTPUT_INCONS ((TLR_RESULT)0xC0470109L)

//
// MessageId: TLR_E_DEVNET_FAL_UNKNOWN_DATA_TYPE
//
// MessageText:
//
//  Unknown data type in of the module definition.
//
#define TLR_E_DEVNET_FAL_UNKNOWN_DATA_TYPE ((TLR_RESULT)0xC047010AL)

//
// MessageId: TLR_E_DEVNET_FAL_MODULE_DATA_SIZE
//
// MessageText:
//
//  Invalid data size in of the module definition.
//
#define TLR_E_DEVNET_FAL_MODULE_DATA_SIZE ((TLR_RESULT)0xC047010BL)

//
// MessageId: TLR_E_DEVNET_FAL_OUTPUT_OFF_RANGE
//
// MessageText:
//
//  Output address offset exceeds the maximum allowed area.
//
#define TLR_E_DEVNET_FAL_OUTPUT_OFF_RANGE ((TLR_RESULT)0xC047010CL)

//
// MessageId: TLR_E_DEVNET_FAL_INPUT_OFF_RANGE
//
// MessageText:
//
//  Input address offset exceeds the maximum allowed area.
//
#define TLR_E_DEVNET_FAL_INPUT_OFF_RANGE ((TLR_RESULT)0xC047010DL)

//
// MessageId: TLR_E_DEVNET_FAL_WRONG_TYPE_OF_CONNECTION
//
// MessageText:
//
//  Invalid type of connection configured.
//
#define TLR_E_DEVNET_FAL_WRONG_TYPE_OF_CONNECTION ((TLR_RESULT)0xC047010EL)

//
// MessageId: TLR_E_DEVNET_FAL_TYPE_CONNECTION_REDEFINITION
//
// MessageText:
//
//  Redifinition of connection type.
//
#define TLR_E_DEVNET_FAL_TYPE_CONNECTION_REDEFINITION ((TLR_RESULT)0xC047010FL)

//
// MessageId: TLR_E_DEVNET_FAL_EXP_PACKET_LESS_PROD_INHIBIT
//
// MessageText:
//
//  Configured 'Production Inhibit Time' is smaller then 'Expected Packet Rate'.
//
#define TLR_E_DEVNET_FAL_EXP_PACKET_LESS_PROD_INHIBIT ((TLR_RESULT)0xC0470110L)

//
// MessageId: TLR_E_DEVNET_FAL_PRM_FIELD_LEN_INCONSISTENT
//
// MessageText:
//
//  Invalid length of parameter field in slave parameter set.
//
#define TLR_E_DEVNET_FAL_PRM_FIELD_LEN_INCONSISTENT ((TLR_RESULT)0xC0470111L)

//
// MessageId: TLR_E_DEVNET_FAL_SET_BAUDRATE_FAIL
//
// MessageText:
//
//  Error while setting baudrate.
//
#define TLR_E_DEVNET_FAL_SET_BAUDRATE_FAIL ((TLR_RESULT)0xC0470112L)

//
// MessageId: TLR_E_DEVNET_FAL_REG_FRAG_TIMEOUT_OUT_OF_RANGE
//
// MessageText:
//
//  Invalid value of fragmentation timeout.
//
#define TLR_E_DEVNET_FAL_REG_FRAG_TIMEOUT_OUT_OF_RANGE ((TLR_RESULT)0xC0470113L)

//
// MessageId: TLR_E_DEVNET_FAL_PRM_OUT_MEMORY
//
// MessageText:
//
//  Out of memory for configuration data.
//
#define TLR_E_DEVNET_FAL_PRM_OUT_MEMORY  ((TLR_RESULT)0xC0470114L)

////////////////////////////////////////////////////////////////////////////////
// Error Command:  GetSetAttributeReq 0x200 - 0x2FF
////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_DEVNET_FAL_CON_NA
//
// MessageText:
//
//  No response from device.
//
#define TLR_E_DEVNET_FAL_CON_NA          ((TLR_RESULT)0xC0470211L)

//
// MessageId: TLR_E_DEVNET_FAL_CON_MDA
//
// MessageText:
//
//  To much data received.
//
#define TLR_E_DEVNET_FAL_CON_MDA         ((TLR_RESULT)0xC0470215L)

//
// MessageId: TLR_E_DEVNET_FAL_CON_LE
//
// MessageText:
//
//  Invalid length of requested service.
//
#define TLR_E_DEVNET_FAL_CON_LE          ((TLR_RESULT)0xC0470233L)

//
// MessageId: TLR_E_DEVNET_FAL_CON_AD
//
// MessageText:
//
//  Another service still active.
//
#define TLR_E_DEVNET_FAL_CON_AD          ((TLR_RESULT)0xC0470236L)

//
// MessageId: TLR_E_DEVNET_FAL_CON_SE
//
// MessageText:
//
//  Sequence error in response sequence.
//
#define TLR_E_DEVNET_FAL_CON_SE          ((TLR_RESULT)0xC0470239L)

//
// MessageId: TLR_E_DEVNET_FAL_CON_OC
//
// MessageText:
//
//  Explicit Message Handler is occupied.
//
#define TLR_E_DEVNET_FAL_CON_OC          ((TLR_RESULT)0xC0470240L)

//
// MessageId: TLR_E_DEVNET_FAL_CON_ERR_RES
//
// MessageText:
//
//  Service Error Response.
//
#define TLR_E_DEVNET_FAL_CON_ERR_RES     ((TLR_RESULT)0xC0470294L)

////////////////////////////////////////////////////////////////////////////////
// Error Command: InitReq
////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_DEVNET_FAL_LIFELIST_IN_PROGRESS
//
// MessageText:
//
//  Lifelist request in progress.
//
#define TLR_E_DEVNET_FAL_LIFELIST_IN_PROGRESS ((TLR_RESULT)0xC0470295L)

//
// MessageId: TLR_E_DEVNET_FAL_BTS_IN_PROGRESS
//
// MessageText:
//
//  Bitstrobe request in progress.
//
#define TLR_E_DEVNET_FAL_BTS_IN_PROGRESS ((TLR_RESULT)0xC0470296L)

//
// MessageId: TLR_E_DEVNET_FAL_BUS_NOT_ONLINE
//
// MessageText:
//
//  Bus not communicating.
//
#define TLR_E_DEVNET_FAL_BUS_NOT_ONLINE  ((TLR_RESULT)0xC0470297L)

//
// MessageId: TLR_E_DEVNET_FAL_24V_NETWORK_POWER_MISSING
//
// MessageText:
//
// 24V Network Power Missing
//
#define TLR_E_DEVNET_FAL_24V_NETWORK_POWER_MISSING  ((TLR_RESULT)0xC0470298L)

////////////////////////////////////////////////////////////////////////////////
// Error : Data exchange related
////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_DEVNET_FAL_SLAVE_NOEXCHANGE
//
// MessageText:
//
//  Service Error Response.
//
#define TLR_E_DEVNET_FAL_SLAVE_NOEXCHANGE ((TLR_RESULT)0xC0471000L)




#endif  //__DEVNET_FAL_ERROR_H

